/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.data.tag;

import com.google.common.collect.Maps;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class TagRegistry<T, P extends RegistrateTagsProvider<T>> {
    protected final String namespace;
    protected final ResourceKey<? extends Registry<T>> registry;
    protected final Map<TagKey<T>, ProviderEntry> providerEntries;
    protected final Map<TagKey<T>, String> localizations;

    public TagRegistry(String namespace, ResourceKey<? extends Registry<T>> registry) {
        this.namespace = namespace;
        this.registry = registry;
        this.providerEntries = Maps.newConcurrentMap();
        this.localizations = new HashMap<TagKey<T>, String>();
    }

    public final TagKey<T> tag(String path) {
        return TagKey.create(this.registry, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)path));
    }

    public final TagKey<T> tag(String path, String localization) {
        TagKey<T> tag = this.tag(path);
        this.localizations.put(tag, localization);
        return tag;
    }

    protected ProviderEntry getEntry(TagKey<T> tag) {
        return this.providerEntries.computeIfAbsent(tag, x$0 -> new ProviderEntry(this, x$0));
    }

    public final void add(TagKey<T> tag, ResourceKey<T> value) {
        this.getEntry(tag).values.add(value);
    }

    public final void addOptional(TagKey<T> tag, ResourceLocation value) {
        this.getEntry(tag).optionalValues.add(value);
    }

    public final void addTag(TagKey<T> tag, TagKey<T> value) {
        this.getEntry(tag).tagValues.add(value);
    }

    public final void addOptionalTag(TagKey<T> tag, ResourceLocation value) {
        this.getEntry(tag).optionalTagValues.add(value);
    }

    public void generate(P provider) {
        this.providerEntries.values().forEach(entry -> entry.generate(provider));
    }

    public void generate(RegistrateLangProvider provider) {
        this.localizations.forEach((arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1));
    }

    protected class ProviderEntry {
        protected final TagKey<T> tag;
        protected final List<ResourceKey<T>> values = new ArrayList();
        protected final List<ResourceLocation> optionalValues = new ArrayList<ResourceLocation>();
        protected final List<TagKey<T>> tagValues = new ArrayList();
        protected final List<ResourceLocation> optionalTagValues = new ArrayList<ResourceLocation>();

        public ProviderEntry(TagRegistry this$0, TagKey<T> tag) {
            this.tag = tag;
        }

        protected void generate(P provider) {
            TagsProvider.TagAppender tag = provider.addTag(this.tag);
            this.values.forEach(arg_0 -> ((TagsProvider.TagAppender)tag).add(arg_0));
            this.optionalValues.forEach(arg_0 -> ((TagsProvider.TagAppender)tag).addOptional(arg_0));
            this.tagValues.forEach(arg_0 -> ((TagsProvider.TagAppender)tag).addTag(arg_0));
            this.optionalValues.forEach(arg_0 -> ((TagsProvider.TagAppender)tag).addOptional(arg_0));
        }
    }
}

